/********************************************************************
 * (C) Copyright 1998 by Hewlett-Packard GmbH. All rights reserved. *
 ********************************************************************/

/* -----------------------------------------------------------------------
 * File: master.h
 * Author: Joerg Striegel 4.6.96
 * Purpose: This file contains the function prototypes for setting all
 * master block properties and all master attribute page properties and
 * to perform master block transfers
 * ----------------------------------------------------------------------- */

#ifndef MASTER_H_INCLUDED
#define MASTER_H_INCLUDED


#include <masdefs.h>


#ifdef __cplusplus
extern "C" {
#endif


/* --------------------------------------------------------------------------
 * Master Block Property Programming Functions
 * -------------------------------------------------------------------------- */

/* initializes a block page */
CLI  b_errtype EXPORT BestMasterBlockPageInit(                      /* @mbpginit */
					      b_handletype handle,
					      b_int32      page_num /* @page */
					      );


/* sets the default value of the block properties */
CLI  b_errtype EXPORT BestMasterBlockPropDefaultSet(                     /* @mbprpdefset */
						    b_handletype  handle
						    );


CLI b_errtype EXPORT BestMasterBlockPropGet(                              /* @mbprpget */
                                        b_handletype  handle,
                                        b_blkproptype blk_prop,       /* @prop */
                                        b_int32       *value          /* #RETURN "property value: %08lx\\h" */
                                        );


/* set the value of a property for the next programming of an block line */
CLI  b_errtype EXPORT BestMasterBlockPropSet(                        /* @mbprpset */
					     b_handletype  handle,
					     b_blkproptype blk_prop, /* @prop */
					     b_int32       value     /* @val */
				     );


/* belongs to convenience functions, programs one complete line of properties */
CLI b_errtype EXPORT BestMasterAllBlock1xProg(                        /* @mab1xprog */
					      b_handletype handle,
					      b_int32      busaddr,   /* @bad */
					      b_int32      buscmd,    /* @cmd */
					      b_int32      byten,     /* @ben */
					      b_int32      intaddr,   /* @iad */
					      b_int32      nofdwords, /* @nod */
					      b_int32      attrpage,  /* @apage */
					      b_int32      compflag,  /* @cflag */
					      b_int32      compoffset /* @coffs */
					      );


/* programms a block line with the actual value of the property registers */
CLI  b_errtype EXPORT BestMasterBlockProg(                     /* @mbprog */
					  b_handletype  handle
					  );

/* programms a block line with the actual value of the property registers */
CLI  b_errtype EXPORT BestMasterBlockLineProg(                     /* @mblprog */
					  b_handletype  handle,
                      b_int32 page_num,   /* @page */
                      b_int32 offset      /* @offs */
					  );

/* programms an End-of-page block line into block memory */
CLI  b_errtype EXPORT BestMasterBlockEndProg(                     /* @mbeprog */
					  b_handletype  handle,
                      b_int32 page_num,  /* @page */
                      b_int32 offset     /* @offs */
					  );

/* reads one block into preparation register */
CLI  b_errtype EXPORT BestMasterBlockLineRead(                     /* @mblread */
					  b_handletype  handle,
                      b_int32 page_num,    /* @page */
                      b_int32 offset,      /* @offs */
                      b_int32 *eop         /* #RETURN "EOP=%lu" */
					  );


/* --------------------------------------------------------------------------
 * Exerciser Run Functions
 * -------------------------------------------------------------------------- */

/* starts the master with the actual property registers */
CLI  b_errtype EXPORT BestMasterBlockRun(                    /* @mbrun */
					 b_handletype handle
					 );


/* starts the master  with a block page */
CLI  b_errtype EXPORT BestMasterBlockPageRun(                      /* @mbpgrun */
					     b_handletype handle,
					     b_int32      page_num /* @page */
					     );


/* starts the master  with a block page, no initialization done */
CLI  b_errtype EXPORT BestMasterBlockPageRerun(                      /* @mbpgrerun */
					     b_handletype handle,
					     b_int32      page_num /* @page */
					     );


/* stops the master */
CLI b_errtype EXPORT BestMasterStop(                    /* @mstop */
				    b_handletype handle
				    );



/* --------------------------------------------------------------------------
 * PCI Master Behaviour Programming Functions
 * -------------------------------------------------------------------------- */

/* initializes a attrigute page */
CLI  b_errtype EXPORT BestMasterAttrPageInit(                      /* @mapginit  */
					     b_handletype handle,
					     b_int32 page_num      /* @page  */
					     );


/* sets the programming pointes in the specified page to the specified offset */
CLI  b_errtype EXPORT BestMasterAttrPtrSet(                       /* @maptrset */
					   b_handletype handle,
					   b_int32      page_num, /* @page */
					   b_int32      offset    /* @offs */
					   );


/* sets all attribute properties to their specifiec default value */
CLI  b_errtype EXPORT BestMasterAttrPropDefaultSet(                    /* @maprpdefset */
						   b_handletype handle
						   );


/* sets the value ot a master attribute property register */
CLI  b_errtype EXPORT BestMasterAttrPropSet(                           /* @maprpset */
					    b_handletype handle,
					    b_mattrproptype mattrprop, /* @prop */
					    b_int32 value              /* @val */
					    );


/* belongs to convenience functions, programs a complete attribute line */
CLI  b_errtype EXPORT BestMasterAllAttr1xProg(                       /* @maa1xprog */
					      b_handletype handle,
					      b_int32      doloop,   /* @loop */
					      b_int32      waits,    /* @w */
					      b_int32      last,     /* @last */
					      b_int32      dperr,    /* @dperr */
					      b_int32      dserr,    /* @dserr */
					      b_int32      aperr,    /* @aperr */
					      b_int32      dwrpar,   /* @dwp */
					      b_int32      awrpar,   /* @awp */
					      b_int32      drelreq,  /* @drreq */
					      b_int32      stepmode, /* @sm */
					      b_int32      waitmode, /* @wm */
					      b_int32      lock      /* @lock */
					      );


/* read the attributes from the attribute memory at the actual location */
CLI b_errtype EXPORT BestMasterAttrPhaseRead(                     /* @maphread */               
					     b_handletype handle
					     );


/* returns the value ot a master attribute property register */
CLI  b_errtype EXPORT BestMasterAttrPropGet(                      /* @maprpget */
				    b_handletype handle,
				    b_mattrproptype mattrprop,    /* @prop */
				    b_int32   *value              /* #RETURN "property value: %08lx\\h" */
				    );


/* programms a phase in the attribute memory */
CLI  b_errtype EXPORT BestMasterAttrPhaseProg(                    /* @maphprog */
					      b_handletype handle
					      );


/* programms a phase in the attribute memory */
CLI b_errtype EXPORT BestMasterAttrLineProg(                      /* @malprog */
                  b_handletype handle,
                  b_int32 page_num,                                    /* @page */
                  b_int32 offset                                       /* @offs */
                  );

/* programming properties of one group only */
CLI b_errtype EXPORT BestMasterAttrGroupLineProg(                /* @magrplprog */
                  b_handletype handle,
                  b_mattrgrouptype group,                              /* @grp  */
                  b_int32 page_num,                                    /* @page */
                  b_int32 offset                                       /* @offs */
                  );
                  
/* read the attributes from the attribute memory */
CLI b_errtype EXPORT BestMasterAttrLineRead(                      /* @malread */
                  b_handletype handle,           
                  b_int32 page_num,                                    /* @page */
                  b_int32 offset                                       /* @offs */
                  );
                  
/* programming properties of one group only */
CLI b_errtype EXPORT BestMasterAttrGroupLineRead(                /* @magrplread */
                  b_handletype handle,
                  b_mattrgrouptype group,                              /* @grp  */
                  b_int32 page_num,                                    /* @page */
                  b_int32 offset                                       /* @offs */
                  );

/* --------------------------------------------------------------------------
 * PCI Master Generic Property Programming Functions
 * -------------------------------------------------------------------------- */

/* set a generic property to value */
CLI b_errtype EXPORT BestMasterGenPropSet(                                   /* @mgprpset */
					  b_handletype        handle,
					  b_mastergenproptype mastergenprop, /* @prop     */
					  b_int32             value          /* @val      */
					  );

/* sets all generic properies to their specified defautl value */
CLI b_errtype EXPORT BestMasterGenPropDefaultSet(                            /* @mgprpdefset */
						 b_handletype handle
						 );


/* return the value of a generic property */
CLI b_errtype EXPORT BestMasterGenPropGet(                                   /* @mgprpget */
					  b_handletype        handle,
					  b_mastergenproptype mastergenprop, /* @prop     */
					  b_int32             *value         /* #RETURN "property value: %08lx\\h" */
					  );


/* sets the compare pattern for the master conditional start */
CLI b_errtype EXPORT BestMasterCondStartPattSet(                        /* @mcspset */
						b_handletype  handle,
						b_charptrtype pattern    /* @patt */
						);

/* --------------------------------------------------------------------------
 * Accessing Master Byteenable Memory
 * -------------------------------------------------------------------------- */

/* programming into memory */
CLI b_errtype EXPORT BestMasterByteEnableProg(           /* @mbytenprog  */
					  b_handletype        handle,
					  b_int32 offset,                    /* @offs     */
					  b_int32             value          /* @val      */
					  );

/* reading from memory */
CLI b_errtype EXPORT BestMasterByteEnableRead(         /* @mbytenread */
					b_handletype handle,
    			    b_int32 offset,                    /* @offs     */
					b_int32 *value                     /* #RETURN "value: %02lx\\h" */
);

#ifdef __cplusplus
}
#endif

#endif
